<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Messaging\V1;

use Twilio\InstanceContext;
use Twilio\Options;
use Twilio\Serialize;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
class WebhookContext extends InstanceContext {
    /**
     * Initialize the WebhookContext
     * 
     * @param \Twilio\Version $version Version that contains the resource
     * @return \Twilio\Rest\Messaging\V1\WebhookContext 
     */
    public function __construct(Version $version) {
        parent::__construct($version);

        // Path Solution
        $this->solution = array();

        $this->uri = '/Sessions/Webhooks';
    }

    /**
     * Fetch a WebhookInstance
     * 
     * @return WebhookInstance Fetched WebhookInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch() {
        $params = Values::of(array());

        $payload = $this->version->fetch(
            'GET',
            $this->uri,
            $params
        );

        return new WebhookInstance($this->version, $payload);
    }

    /**
     * Update the WebhookInstance
     * 
     * @param array|Options $options Optional Arguments
     * @return WebhookInstance Updated WebhookInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update($options = array()) {
        $options = new Values($options);

        $data = Values::of(array(
            'WebhookMethod' => $options['webhookMethod'],
            'WebhookFilters' => Serialize::map($options['webhookFilters'], function($e) { return $e; }),
            'PreWebhookUrl' => $options['preWebhookUrl'],
            'PostWebhookUrl' => $options['postWebhookUrl'],
            'PreWebhookRetryCount' => $options['preWebhookRetryCount'],
            'PostWebhookRetryCount' => $options['postWebhookRetryCount'],
            'Target' => $options['target'],
        ));

        $payload = $this->version->update(
            'POST',
            $this->uri,
            array(),
            $data
        );

        return new WebhookInstance($this->version, $payload);
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $context = array();
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Messaging.V1.WebhookContext ' . implode(' ', $context) . ']';
    }
}